/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;

public class PathTools {
    public static String getOS() {
        String os = System.getProperty("os.name").toUpperCase();
        if (os.contains("WIN")) {
            return "WIN";
        }
        if (os.contains("MAC")) {
            return "MAC";
        }
        if (os.contains("NUX")) {
            return "LINUX";
        }
        if (os.contains("SOLARIS") || os.contains("SUN")) {
            return "SOLARIS";
        }
        return "MISC";
    }

    public static String getDataDirectory() {
        String os = PathTools.getOS();
        String dir = null;
        dir = os.equals("WIN") ? System.getenv("APPDATA") : (os.equals("MAC") ? String.valueOf(System.getProperty("user.home")) + "/Library/Application " + "Support" : (os.equals("LINUX") ? System.getProperty("user.home") : System.getProperty("user.dir")));
        return String.valueOf(dir) + File.separator + ".MinionInvaders" + File.separator;
    }

    public static String getNativeDirectory() {
        return String.valueOf(System.getProperty("user.dir")) + File.separator + "native" + File.separator + PathTools.getOS().toLowerCase() + File.separator;
    }

    public static void makeSureDataFilesExist() {
        try {
            File levelMi;
            File dataDir = new File(PathTools.getDataDirectory());
            if (!dataDir.exists()) {
                dataDir.mkdir();
            }
            if (!(levelMi = new File(String.valueOf(PathTools.getDataDirectory()) + "level.mi")).exists()) {
                System.out.println("true");
                FileWriter fstream = new FileWriter(levelMi);
                BufferedWriter bw = new BufferedWriter(fstream);
                bw.write("1");
                bw.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

